/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.portal.ui.dispatch.configurationProcessors;

import com.aptana.configurations.processor.AbstractConfigurationProcessor;
import com.aptana.configurations.processor.ConfigurationProcessorsRegistry;
import com.aptana.configurations.processor.ConfigurationStatus;
import com.aptana.configurations.processor.IConfigurationProcessorDelegate;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.VersionUtil;
import com.aptana.jetty.util.epl.ajax.JSON;
import com.aptana.portal.ui.PortalUIPlugin;
import com.aptana.portal.ui.dispatch.configurationProcessors.Messages;
import com.aptana.portal.ui.dispatch.processorDelegates.CachedVersionProcessorDelegate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionsConfigurationProcessor
extends AbstractConfigurationProcessor {
    public ConfigurationStatus computeStatus(IProgressMonitor progressMonitor, Object attributes) {
        this.configurationStatus.removeAttribute("configurations");
        this.clearErrorAttributes();
        if (attributes == null || !(attributes instanceof Object[])) {
            String message = Messages.SystemConfigurationProcessor_missingConfigurationItems;
            this.applyErrorAttributes(message);
            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)new Exception(message));
            return this.configurationStatus;
        }
        Object[] attrArray = (Object[])attributes;
        HashMap<String, String> attrItems = new HashMap<String, String>();
        Object[] objectArray = attrArray;
        int n = attrArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object itemDef = objectArray[n2];
            Object[] def = null;
            if (!(itemDef instanceof Object[]) || (def = (Object[])itemDef).length != 3) {
                String message = Messages.SystemConfigurationProcessor_wrongConfigurationAttributesStructure;
                this.applyErrorAttributes(message);
                IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)new Exception(message));
                return this.configurationStatus;
            }
            attrItems.put((String)def[0], (String)def[1]);
            ++n2;
        }
        this.configurationStatus.setStatus("processing");
        HashMap itemsData = new HashMap();
        String[] apps = attrItems.keySet().toArray(new String[attrItems.size()]);
        Map<String, IConfigurationProcessorDelegate> processorDelegators = this.getVersionDelegators(apps);
        String[] stringArray = apps;
        int n3 = apps.length;
        int def = 0;
        while (def < n3) {
            Version version;
            IConfigurationProcessorDelegate delegate;
            Object commandResult;
            String app = stringArray[def];
            if (processorDelegators.containsKey(app) && (commandResult = (delegate = processorDelegators.get(app)).runCommand("version", this.getActiveWorkingDir())) != null && !VersionUtil.isEmpty((Version)(version = VersionUtil.parseVersion((String)commandResult.toString())))) {
                Version minVersion = VersionUtil.parseVersion((String)((String)attrItems.get(app)));
                String compatibility = version.compareTo(minVersion) >= 0 ? "ok" : "update";
                HashMap<String, String> versionInfo = new HashMap<String, String>(4);
                versionInfo.put("exists", "yes");
                versionInfo.put("version", version.toString());
                versionInfo.put("compatibility", compatibility);
                versionInfo.put("rawOutput", commandResult.toString());
                itemsData.put(app, versionInfo);
                attrItems.remove(app);
            }
            ++def;
        }
        Set missingItems = attrItems.keySet();
        for (String item : missingItems) {
            HashMap<String, String> versionInfo = new HashMap<String, String>(4);
            versionInfo.put("exists", "no");
            itemsData.put(item, versionInfo);
        }
        this.configurationStatus.setAttribute("configurations", JSON.toString(itemsData));
        this.configurationStatus.setStatus("ok");
        return this.configurationStatus;
    }

    public ConfigurationStatus configure(IProgressMonitor progressMonitor, Object attributes) {
        return this.configurationStatus;
    }

    private Map<String, IConfigurationProcessorDelegate> getVersionDelegators(String[] apps) {
        HashSet<String> appsSet = new HashSet<String>();
        String[] stringArray = apps;
        int n = apps.length;
        int n2 = 0;
        while (n2 < n) {
            String app = stringArray[n2];
            appsSet.add(app);
            ++n2;
        }
        Set allDelegators = ConfigurationProcessorsRegistry.getInstance().getProcessorDelegators(this.getID());
        HashMap<String, IConfigurationProcessorDelegate> delegators = new HashMap<String, IConfigurationProcessorDelegate>();
        for (IConfigurationProcessorDelegate delegate : allDelegators) {
            if (!appsSet.contains(delegate.getSupportedApplication()) || !delegate.getSupportedCommands().contains("version")) continue;
            delegators.put(delegate.getSupportedApplication(), delegate);
            appsSet.remove(delegate.getSupportedApplication());
        }
        for (String app : appsSet) {
            delegators.put(app, (IConfigurationProcessorDelegate)new CachedVersionProcessorDelegate(app));
        }
        return delegators;
    }

    protected IPath getActiveWorkingDir() {
        IPreferencesService preferencesService = Platform.getPreferencesService();
        String activeProjectName = preferencesService.getString("com.aptana.explorer", "activeProject", null, null);
        IProject result = null;
        if (activeProjectName != null) {
            result = ResourcesPlugin.getWorkspace().getRoot().getProject(activeProjectName);
        }
        if (result == null) {
            return null;
        }
        return result.getLocation();
    }
}

